// Tracker_alphaBeta.cpp: implementation of the Tracker_alphaBeta class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Tracker_alphaBeta.h"
#include "EchoCache.h"
#include "Track.h"

#include <math.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Tracker_alphaBeta::Tracker_alphaBeta()
{
	// initialize Tracker parameters
	alg = alphaBetaTracker;
	alpha = 0.6;			// velocity update scaling parameter
	beta  = 0.6;			// position update scaling parameter
	gate  = 2;				// radius of range gate [samples]
}


Tracker_alphaBeta::~Tracker_alphaBeta(){}

void Tracker_alphaBeta::Deactivate(void) {/* STUB:  Do any cleanup*/}

TRACKER_ERRORS Tracker_alphaBeta::Activate(void)
{
	trackerOn = trackerRunning ;
	return (TrackerSuccess) ;
}
	
TRACKER_ERRORS  Tracker_alphaBeta::RunAlphaBeta(long ping)
{	
	TRACKER_ERRORS rtn = TrackerSuccess ;
	EchoCacheElement *firstEcho = cachedEchoes.getFirstEcho(ping) ;
	rtn = association(ping, firstEcho) ;
	if (rtn == TrackerSuccess)
	{ rtn = prediction(ping, firstEcho) ;}

	return(rtn) ;
}

TRACKER_ERRORS Tracker_alphaBeta::SetTrackerParam(double alphaIn, 
									double betaIn, double Gate){

	gate = Gate ;	// initial gate size [samples]
	alpha = alphaIn ;	// scaling parameter for velocity update
	beta = betaIn;		// scaling parameter for position update
	return (TrackerSuccess) ;
}


TRACKER_ERRORS Tracker_alphaBeta::association(long ping, EchoCacheElement * firstEcho)
{
	const float INFINITY = 10000;
	
	TRACKER_ERRORS rtn = TrackerSuccess ;  // ok
	Track * track;
	EchoCacheElement *echo, *nearestEcho ;
	float closest, distance;
	int ntrack = 0, nSkipped = 0;
	
	for(track = (Track *)getFirstActiveTrack(); 
		track != NULL;track = (Track *)getNextActiveTrack(track))
	{
		closest = INFINITY;
		for (echo = cachedEchoes.getFirstEcho(ping); echo != NULL;
							echo = cachedEchoes.getNextEcho(ping, echo))
		{
			//	calculate the distance of the closest echo
			if (echo->getTrackAssociation() == INVALID_TRACK) 
			{
				distance = (float)fabs((echo->getRange()) 
								- (float)(track->expectedPosition));
				if (distance<closest ) 
				{
					closest = distance;
					nearestEcho = echo;
				}
			}
		}
		
		if (closest<gate) // then the echo is associated with the track
		{	
			track->addtoTrack(nearestEcho);
			nearestEcho->setTrackAssociation(track->uid);
		}
		else // Else consider terminating the track
		{	
			if (shouldEndTrack(track, ping))
			{	
				track->terminateTrack();
			}
			else // if the track wasn't terminated add 1 to nSkipped
			{	
				nSkipped++;
			}	
		}	
	}
	
	//	Generate new tracks for unassigned echoes
	for (echo = firstEcho; echo != NULL;  
				echo = cachedEchoes.getNextEcho(ping, echo)){
		if(echo->getTrackAssociation() == INVALID_TRACK){
			track = (Track *)allocTrack();
			if (track != NULL){
				track->initTrack(echo) ; 
				echo->setTrackAssociation(track->uid) ;
			}
			ntrack++;
		}
	}
	char  * dumpFile  = "Cache Dump.txt";
	cachedEchoes.DumpCache(dumpFile);
	NumActive_Tracks = ntrack + nSkipped;
	return (rtn);
}

TRACKER_ERRORS Tracker_alphaBeta::prediction(long ping, EchoCacheElement *firstEcho)
{	
	int current = ping, next = ping +1;
	TRACKER_ERRORS rtn = TrackerSuccess ;
	double error;

	for(Track *track = (Track *)getFirstActiveTrack(); track != NULL ;
		track = (Track *)getNextActiveTrack(track)) {
	
	/* 	
	Problem?
	JB's prediction method does not take into account dropped pings and 
	gaps in a track. It is unclear how one should proceed...	
	
	This code does not handle variantions or changes in ping frequency.
	Ping rate will effect the relationship between prediction and observation.
	*/
	// using 'error to simplify equations
	error = (track->currentPosition - track->expectedPosition);

	// update velocity
	track->velocity = track->velocity + ( alpha ) * error;

	// update estimate
	track->expectedPosition = track->expectedPosition 
						+ track->velocity + (beta * error);
	}
	return (rtn);
}

bool Tracker_alphaBeta::shouldEndTrack(Track *track, long ping)
{
	// figure out if the gapin the track warrants termination
	bool rtn = true;
	int gap;

	// May need to set a more sophisticated policy on when 
	// a track should be terminated.For now just use size of gap.
	gap = ping - (track->stop);
	rtn = (gap>=terminationThreshold);
	return (rtn);
}
